# ar‑mass‑gap‑validation

This repository provides a reproducible pipeline to validate the **mass‑gap prediction** of the *Absolute Relativity* theory by measuring the smallest non‑zero eigenvalue of the **Composite Moment Operator (CMO)** across different gauge groups (U(1), SU(2), SU(3)).  It is designed as an independent testbed built on top of the Volume 4 pipeline components.  The extended version presented here incorporates a **finite‑size scaling study** on larger lattices (up to \(L=20\)) and performs both linear and nonlinear continuum‑limit extrapolations using polynomial and exponential fits.

## Overview

The pipeline performs the following tasks:

1. **Data preparation:** a real flip‑count vector (length 32) generated by the flip‑count simulator is provided in `data/flip_counts.npy`.  The reproduction‑kernel eigenvalues (length 32) obtained from the Volume 3 eigenanalysis are stored in `data/kernel.npy`.
2. **Mass‑gap computation:** `scripts/run_mass_gap.py` loads the data and loops over an ensemble of noisy flip‑count samples and a sweep of pivot parameters (`b` and logistic slope `k`) and lattice sizes (`L`).  For each trial it builds the link variables \(U_\mu(i)\), constructs the CMO and extracts the smallest non‑zero eigenvalue, recording the result in a CSV file.
3. **Analysis and report:** `scripts/generate_report.py` aggregates the results, computes mean ± standard deviation for each parameter set, produces plots of mass gap versus pivot parameters and lattice size, performs continuum extrapolations.  Both a **linear extrapolation** in \(1/L\) and **nonlinear finite‑size fits** are computed: a polynomial ansatz \(m(L) = m_\infty + A/L + B/L^2\) and an exponential ansatz \(m(L) = m_\infty + C\,e^{-DL}\).  The script writes a comprehensive report (`REPORT_mass_gap_final.md`) summarising the findings, including tables of fit parameters and comparisons with the theoretical pivot‑formula predictions.

## Usage

After cloning the repository, install the Python dependencies and run the computation and report generation scripts:

```bash
git clone <repo-url> mass-gap-validation
cd mass-gap-validation
pip install -r requirements.txt

# Run the full ensemble and parameter sweep (now includes lattice sizes 4–20)
python scripts/run_mass_gap.py

# Generate summary figures and a Markdown report with continuum extrapolation and nonlinear fits
python scripts/generate_report.py
```

The results of the simulation will be written to `results/mass_gap_full.csv`.  Summary figures will be saved in `results/figures/`, and a comprehensive report will be written to `REPORT_mass_gap_final.md`.

## Configuration

Simulation parameters are defined in `config.yaml`.  You can adjust the ranges of the pivot parameters (`b_range` and `k_range`), the set of lattice sizes and the ensemble size.  The script will automatically read this configuration file at run time.